﻿/*
VERSION:		1.0

USAGE:
	#include "writeXmlAsync.as"
	myXml = new XML();
	convert_vow = writeXmlAsync( myData, myXml );
	convert_vow.then( someFunc );
	
WHAT IS THIS:
	This is a performance-sensitive version of writeXml()
	Both writeXml() and writeXmlAsync() convert an artbitrary object and all of its children into XML data
	
NOTE:
	Everything is stored inside a <data> tag.
*/


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// XML Writing function
writeXmlAsync = function( targetObject, targetXml, rootName )
{
	#include "VOW.as"
	var uid = Math.floor(Math.random()*9999);
	
	// Resolve optional parameters
	var rootName = (rootName) ? rootName : "data";
	
	// performance manager
	var startTime = getTimer();
	var delayThresh = 15;		// milliseconds		(how much computing time to spend on this task  (out of 34 total)
	var reliefTime = 34 -delayThresh +0;	//(how much time to leave for other tasks)
	var checkPerformance = function()
	{
		var uid = Math.floor(Math.random()*9999);
		var vow;	// defined later
		
		var endTime = getTimer();
		var delay = endTime -startTime;
		//if( delay > delayThresh )
		if( true )
		{// if:  too much time has passed
			startTime = endTime;
			//vow = VOW.firstWait(34);
			vow = VOW.make();
			VOW.firstWait( reliefTime )
				.then( function(){
					vow.keep();
				});
		}// if:  too much time has passed
		else
		{// if:  there's still more time
			vow = VOW.make().keep();
		}// if:  there's still more time
		
		return vow.promise;
	}// checkPerformance();
	
	
	
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	// private functions
	var scanObject = function( parentData, targetPath:XMLNode )
	{
		var uid = Math.floor(Math.random()*9999);
		
		// scan_vow  (inherited from child function:  writeNextNode()
		
		// make a list of all the children within the current object
		var childList = [];
		for (var childName in parentData)
			childList.push(childName);
		
		
		
		// write attributes
		var writeThisAttribute = function( childName )
		{
			// This function doesn't make a VOW because it doesn't use any recursion. It only does a single task. Therefore, performance checks can be fully handled by its caller.
			var childPath,
					childType;
			
			childPath = parentData[childName];
			
			var targetPath2:XMLNode = targetPath;		// XML target, can be altered if this is an array
			var childName2 = childName;						// variable name, can be altered if this is an array
			
			if ( typeof( childPath ) == "object")
			{
				if (childPath.length == undefined)
				{// if:  object
					// this is an object
					childType = "object"
				}// if:  object
				else
				{// if:  array
					// this is an array
					childType = "array";
				}// if:  array
			}// if:  some kind of "object"
			else
			{// if:  variable
				// this is a regular variable
				childType = "variable";
			}// if:  variable
			
			
			// write variables
			// // ignore all other types of data  (objects, arrays)
			if ( childType == "variable")
			{
				// store variable type
				// // bol
				if( typeof(childPath) == "boolean" ){
					childPath = "bol_"+String(childPath);
				}// if:  boolean
				// // num
				else if( typeof(childPath) == "number" ){
					childPath = "num_"+String(childPath);
				}// if:  number
				// // str
				else if( typeof(childPath) == "string" ){
					childPath = "str_"+String(childPath);
				}// if:  string
				
				// if the name is a number, then create a node for this array element
				if ( isNaN( Number(childName)) == false )
				{
					// childName is a number, therefore it as an array element
					// add element node  &  set targetPath2 to this new node (for attribute-writing)
					delete targetPath2;
					var targetPath2:XMLNode = addNode( childName, targetPath );
					childName2 = "value";
					addAttr( targetPath2, "xmlType", "variable" );
				}// if:  number
				// write the current variable as an attribute
				addAttr( targetPath2, childName2, childPath );
			}// if:  variable
			
		}// writeThisAttribute()
		
		
		var aIndex = 0;
		var writeNextAttribute = function()
		{
			var uid = Math.floor(Math.random()*9999);
			var writeNextAttribute_vow = VOW.make();
			
			if( aIndex < childList.length )
			{// if:  still more children to convert
				var childName = childList[aIndex];
				aIndex++;
				
				var callWriteThisAttribute = function(){
					return writeThisAttribute( childName );
				}// callWriteThisNode()
				
				checkPerformance()
					.then( callWriteThisAttribute )
					.then( writeNextAttribute )
					.then( function(){
						writeNextAttribute_vow.keep();
					} );
			}// if:  still more children to convert
			else
			{// if:  converted all children
				writeNextAttribute_vow.keep();
			}// if:  converted all children
			
			return writeNextAttribute_vow.promise;
		}// writeNextAttribute()
		
		
		
		// write nodes
		var writeThisNode = function( childName )
		{
			var uid = Math.floor(Math.random()*9999);
			var writeThisNode_vow = VOW.make();
			
			var childPath,
					childType;
			
			childPath = parentData[childName];
			
			childType = "";
			if ( typeof( childPath ) == "object")
			{
				if (childPath.length == undefined)
				{
					// this is an object
					childType = "object"
				}// if:  object
				else
				{// if:  array
					// this is an array
					childType = "array";
				}// if:  array
			}// if:  dome kind of "object"
			else
			{// if:  variable
				// this is a regular variable
				childType = "variable";
			}// if:  variable
			
			
			// write objects, arrays, variable elements
			// // ignore regular variables  (not array elements)
			if ( childType == "variable" )
			{
				// if this child is a variable, then there's nothing more to do, so continue
				writeThisNode_vow.keep();
			}// if:  variable
			
			if ( childType == "object" )
			{
				var newNode:XMLNode = addNode( childName, targetPath );
				addAttr( newNode, "xmlType", "object" );
				//writeThisNode_vow = scanObject( childPath, newNode );
				writeThisNode_vow = VOW.make();
				scanObject( childPath, newNode )
					.then( function(){
						writeThisNode_vow.keep();
					});
			}// if:  object
			
			if ( childType == "array" )
			{
				// create array node
				var newNode:XMLNode = addNode( childName, targetPath );
				addAttr( newNode, "xmlType", "array" );
				//writeThisNode_vow = scanObject( childPath, newNode );
				writeThisNode_vow = VOW.make();
				scanObject( childPath, newNode )
					.then( function(){
						writeThisNode_vow.keep();
					});
			}// if:  array
			
			return writeThisNode_vow.promise;
		}// writeThisNode()
		
		
		
		var nIndex = 0;
		var writeNextNode = function()
		{
			var uid = Math.floor(Math.random()*9999);
			var writeNextNode_vow = VOW.make();
			
			if( nIndex < childList.length )
			{// if:  still more children to convert
				var childName = childList[nIndex];
				nIndex++;
				
				var callWriteThisNode = function(){
					return writeThisNode( childName );
				}// callWriteThisNode()
				
				checkPerformance()
					.then( callWriteThisNode )
					.then( writeNextNode )
					.then( function(){
						writeNextNode_vow.keep();
					} );
			}// if:  still more children to convert
			else
			{// if:  converted all children
				writeNextNode_vow.keep();
			}// if:  converted all children
			
			return writeNextNode_vow.promise;
		}// writeNextNode()
		
		
		//var scan_vow = writeNextNode();
		var scan_vow = VOW.make();
		writeNextAttribute()				// write all the attributes first
			.then( writeNextNode )		// then write all the nodes
			.then( function(){				// then the entire scan is complete
				scan_vow.keep();
			});
		
		return scan_vow.promise;
	}// scanObject()
	
	
	
	var addNode = function( newNodeName:String, xmlPath:XMLNode )
	{
		var tempXml = new XML();
		var newNode:XMLNode = tempXml.createElement(newNodeName);
		delete tempXml;
		xmlPath.appendChild(newNode);
		var newXmlPath:XMLNode = xmlPath.lastChild;
		
		return newXmlPath;
	}// addNode()
	
	var addAttr = function( targetNode, newVariable, newValue )
	{
		targetNode.attributes[newVariable] = newValue;
	}// addAttr()
	// END:	private functions
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

	
	
	
	
	
	
	// Manually create an "object" type of node in the xml, to store loose variables
	var xmlParentPath:XMLNode = targetXml;
	var newXmlTarget:XMLNode = addNode(rootName, xmlParentPath);
	addAttr( newXmlTarget, "xmlType", "object" );
	
	//var convert_vow = scanObject( targetObject, newXmlTarget );
	convert_vow = VOW.make();
	scanObject( targetObject, newXmlTarget )
		.then( function(){
			convert_vow.keep();
		});
	
	// enable then() after this conversion finishes
	return convert_vow.promise;
}// writeXmlAsync()